
/*
tarzeau@space.ch

greets to all the mekka/symposium attenders
*/

#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <iostream>

#include <ggi/ggi.h>
#include <ggi/gii.h>

#include "sprites.h"
#include "filesize.h"
#include "timer.h"
#include "font.h"
#include "pcx.h"

#define SKY 1
#define CLOUD 247
#define SUN 213
#define MEADOW 64
#define EARTH 76
#define RED 20

#define DO_DEMO 1

   sprite cow;
   sprite cowleft;
   int lastdir=0;
   const int BLOECKE=16   /*32*/ ;

   int a[BLOECKE+1];   //ground left, right
   int b[BLOECKE+1];   //height of the ground
   float x,y;

   int speedtotal = 0;
   int lives = 3;
   int i;
   int fall;
   int stanna;
   float yp;
   //int hejsan;
   int pm;
   ggi_color pal[256];
   ggi_pixel fgpix/*, bgpix*/;

int random(int max)
{
   return ((int)(rand()/(RAND_MAX+1.0)*max));
}

void gl_linebf(int x1,int y1,int x2,int y2, int color)
{
   if (x1>x2) {
      int x3=x2;
      x2=x1;
      x1=x3;
   }
   fgpix=ggiMapColor(cow.vis,&pal[color]);
   ggiSetGCForeground(cow.vis,fgpix);
#if 0
   for (int x=x1; x<x2+1; x++) {
      ggiDrawLine(cow.vis, x,y1,x,y2);
   }
#else
   ggiDrawBox(cow.vis, x1, y1, x2-x1, y2-y1);
#endif
   ggiFlushRegion(cow.vis, x1, y1, x2, y2);
}

void circle(float xcent, float ycent, int rad, int color)
{
   fgpix=ggiMapColor(cow.vis,&pal[color]);

   float x = 0, x2 = 0;
   float y = rad, y2 = 2*rad;
   long r2 = rad * rad;
//   if (rad != 0) {
      ggiSetGCForeground(cow.vis,fgpix);
      while (!(x > y)) {
         //if (y>vga_getydim()-1) break;
         //if (y<0) continue;

         ggiDrawHLine(cow.vis,(int)xcent - (int)x, (int)ycent - (int)y, (int)rad/2 +(int)x2);
         ggiDrawHLine(cow.vis,(int)xcent - (int)y, (int)ycent - (int)x, (int)rad/2 +(int)y2);
         ggiDrawHLine(cow.vis,(int)xcent - (int)y, (int)ycent + (int)x, (int)rad/2 +(int)y2);
         ggiDrawHLine(cow.vis,(int)xcent - (int)x, (int)ycent + (int)y, (int)rad/2 +(int)x2);

         x = x + 0.5;
         if (r2 - x * x >= 0) {
				y = sqrt(r2 - x * x);
			}
	 x2 = 2*x;
	 y2 = 2*y;
      }
      ggiFlushRegion(cow.vis, (int)(xcent-x2), (int)(ycent-y2), (int)(2*rad+x2), (int)(2*rad+y2));
//   }
}

void clearcow(int x, int y)
{
   ggi_pixel old_color;
   ggiGetGCForeground(cow.vis, &old_color);
   ggiSetGCForeground(cow.vis, (ggi_pixel)SKY);
   ggiDrawBox(cow.vis,x-12,y-20,26,21);
   ggiFlushRegion(cow.vis, x-12, y-20, 26,21);
   ggiSetGCForeground(cow.vis, old_color);
}

void drawcow (int x, int y)
{
//fprintf(stderr,"%s:%d: x=%d y=%d\n", __FUNCTION__,__LINE__,x,y);
   cow.setpos(x-12,y-19);
   if (lastdir!=-1)  {
      cow.draw();
   } else {
      cow.leftright();
      cow.draw();
      cow.leftright();
   }
   ggiFlushRegion(cow.vis, x-12, y-19,x+13, y+1);
}

void drawleftcloud()
{
   ggiSetGCForeground(cow.vis, (ggi_pixel)CLOUD);
   ggiDrawLine(cow.vis, 90,50,190,50);
   ggiDrawLine(cow.vis, 90,51,190,51);
   ggiDrawLine(cow.vis, 120,52,195,52);
   ggiDrawLine(cow.vis, 120,53,195,53);
   ggiDrawLine (cow.vis, 115, 49,165, 49);
   ggiDrawLine (cow.vis, 140, 54,160, 54);
   ggiFlushRegion(cow.vis, 90,49,105,5);
}

void drawrightcloud()
{
   ggiSetGCForeground(cow.vis, (ggi_pixel)CLOUD);
   ggiDrawLine(cow.vis, 180,30,260,30);
   ggiDrawLine(cow.vis, 180,31,260,31);
   ggiDrawLine(cow.vis, 190,28,245,28);
   ggiDrawLine(cow.vis, 190,29,245,29);
   ggiDrawLine (cow.vis, 205, 27,220, 27);
   ggiDrawLine (cow.vis, 195, 32,275, 32);
   ggiDrawLine (cow.vis, 200, 33,230, 33);
   ggiFlushRegion(cow.vis, 180,27,95,6);
}

inline void drawsun (int x, int y)
{
   circle (x, y, 12, SUN);
}

static pcx16 bild;

void lesbenfickenbesser()
{
   ggi_visual_t memvis = ggiOpen("display-memory", NULL);
   ggiSetSimpleMode(memvis, 25, 20, 1, GT_8BIT);

   bild=pcx16_load(memvis, "./supercow.pcx");
//ggiSetGCForeground(cow.vis,ggiMapColor(cow.vis,&pal[1]));
//ggiFillscreen(cow.vis);
//ggiFlush(cow.vis);
    for (int x=0; x<bild->w; x++) {
       for (int y=0; y<bild->h; y++) {
          if ((bild->buf8[y*bild->w+x]<128) && (0!=bild->buf8[y*bild->w+x]))
		  ggiPutPixel(memvis,x,y,bild->buf8[y*bild->w+x]);
//	  else
//	    ggiPutPixel(memvis,x,y,ggiMapColor(cow.vis,&pal[1]));
       }
    }
    ggiCrossBlit(memvis, 0,0,25,20,cow.vis,0,0);

    cowleft.get(0,0,25,20);
    cow.get(0,0,25,20);
#if 0
    for (int x=0;x<bild->w; x++) {
      for (int y=0; y<bild->h; y++) {
        if (bild->buf8[y*bild->w+x] == 129) /* red key */
fprintf(stderr,"x=%i, y=%i RED\n",x,y);
	  ggiPutPixel(cow.vis,x,y,ggiMapColor(cow.vis,&pal[SKY]));
      }
    }
    cow.get(0,0,25,20);
#endif
#if 0
   cow.setpos(64,1);
   cow.draw();
   cowleft.setpos(128,1);
   cowleft.draw();
   cow.setpos(32,32);
   cow.drawscaled(13,10);
//    ggiFlush(cow.vis);
ggiGetc(cow.vis);
#endif
   pcx16_free(bild);
}

int main(int argc, char **argv)
{
   char string[80];
   ggi_mode mode;
    //int r,g,d;
   int n;
   int cheat=0;
   int lastcheat=0;
  font fnt;
   fnt.load("ocr.fnt");

   ggiInit();
   cow.vis = cowleft.vis = fnt.vis = ggiOpen(NULL);
   if (!cow.vis) {
 vis_failed:
	   std::cerr << "Failed to open visual" << std::endl;
	   std::cerr << "try GGI_DISPLAY=\"tile:0,0,320,200,(palemu:auto)\" " << argv[0] <<
		   std::endl;
	   return 1;
   }
   ggiSetFlags(cow.vis, GGIFLAG_ASYNC);

//   ggiSetSimpleMode(cow.vis, GGI_AUTO, GGI_AUTO, /*frames=*/1, GT_8BIT);
   if (ggiSetSimpleMode(cow.vis, 320, 200, 1, GT_8BIT) ||
       ggiGetMode(cow.vis, &mode))
       goto vis_failed;
#if 0
   if (GT_SCHEME(mode.graphtype) == GT_PALETTE) {
	   ggiSetColorfulPalette(cow.vis);
	   ggiGetPalette(cow.vis, 0, 1<<GT_DEPTH(mode.graphtype), pal);
   }
#endif
   ggiSetGCClipping(cow.vis,0,0,mode.visible.x-1,mode.visible.y-1);

   /*XXX
   for (n=0;n<128; n++) {
      gl_getpalettecolor(n,&r,&g,&d);
      gl_setpalettecolor(n+128,r,g,d);
   }*/
   

   ggiGetPalette(cow.vis, 0, 1<<GT_DEPTH(mode.graphtype), pal);
   lesbenfickenbesser();
#if 0
   for (n=0;n<=256;++n) {
	   fprintf(stderr,"pal[%i]=%x\n",n,ggiMapColor(cow.vis,&pal[n]));

//     bgpix=ggiMapColor(cow.vis, (ggi_color){0,0,0xffff,0});
//     fgpix=ggiMapColor(cow.vis, (ggi_color){0,0,0xffff,0});
     ggiSetGCForeground(cow.vis, ggiMapColor(cow.vis,&pal[n]));
     ggiFillscreen(cow.vis);
     ggiFlush(cow.vis);
     wait(1);
    }
#endif
   wait(2);
 
/*
   for (i=0;i<256;i++) {
   gl_linebf(0,17,319,140,i);

ggiFlush(cow.vis);
fprintf(stderr,"i=%i\n",i);
ggiGetc(cow.vis);
   }
*/

#if DO_DEMO
   ggiDrawLine(cow.vis,0,0,319,0);
   fnt.setpos(16*8,1);
   fnt.color(15+128,0);

   fnt.writestring("SU");
   wait(1.5);

   fnt.writestring("PER");
   wait(0.8);

   fnt.writestring("COW");
   wait(1.3);

   gl_linebf(0,17,319,140,SKY);   //sky  106
   gl_linebf(0,133,180,140, EARTH); //braun
   gl_linebf(0,131,180,133, MEADOW); //grn
//   wait(1.5);

   drawleftcloud();
   wait(0.7);
   drawrightcloud();
   wait(1);
   drawsun(70,40);
   wait(2);

   //intro
   fnt.setpos(0,22*8);
   fnt.color(128+15,0);
   fnt.writestring("     press -> to walk to right side    ");
   for (n=-25;n<175;n++) {
      drawcow(n,140-10);
wait(.01);
      //vga_waitretrace(); //not necessarly, but too fast on fast computers
      clearcow(n,140-10);
   }
   wait(1);

   //umkehr die kuh
   cow.leftright();
   fnt.setpos(0,22*8);
   fnt.color(128+15,0);
   fnt.writestring("     press <- to walk to left side    ");
   for (n=175;n>50;n--) {
      drawcow(n,140-10);
wait(.01);
      //vga_waitretrace(); //not necessarly, but too fast on fast computers
      clearcow(n,140-10);
   }
   cow.leftright();
   wait(0.7);

   //hpfend in den abgrund
   float hoeh=0;
   float gump=1;
   fnt.setpos(0,22*8);
   fnt.color(128+15,0);
   fnt.writestring("        press space or up to jump      ");
   wait(1);
   for (n=50;n<280;n++) {
      //drawcow(n,140-10-(int)(fl*2));
      cowleft.setpos(n-12,140-10-(int)(hoeh)-19);
      cowleft.draw();
      gl_linebf(0,134,180,134-3, 0); //grn
      
wait(.01);
      //vga_waitretrace(); //not necessarly, but too fast on fast computers
      clearcow(n,140-10-(int)(hoeh));
      
      hoeh=hoeh+gump;
      gump-=0.06;
         if (hoeh<=0) {
            gump=-gump;
         } else { 
            if (n>200) {
               break;
               /*if (hoeh<=0) gump=-gump;
               fnt.setpos(0,22*8);
               fnt.color(128+15,0);
               fnt.writestring(" oh and watch out, don't fall in holes ");
               */
            }   
         }
   }
   for (n;n<280;n++) {
      hoeh=hoeh+gump;
      gump-=0.06;
      cowleft.setpos(n-12,140-10-(int)(hoeh)-19);
      cowleft.draw();
      ggiDrawBox(cow.vis,n-22,141,n+20,160);
   fnt.setpos(0,22*8);
   fnt.color(128+15,0);
   fnt.writestring(" oh and watch out, don't fall in holes ");
      ggiFlushRegion(cow.vis, n-22, 141, n+20,160);
wait(.01);
      //vga_waitretrace(); //not necessarly, but too fast on fast computers
      clearcow(n,140-10-(int)(hoeh));
   }
   wait(4);
#endif

   a[1] = 100; 
   a[2] = 220; 
   b[1] = 135 - (int)(random(40));
   // for (n=1; n<(BLOECKE/2)-1 /*15*/ n++) {
   /*a[BLOECKE-1] = hejsan; 
   a[BLOECKE] = hejsan + 10 + 200; 
   b[BLOECKE/2] = 125;*/
   gl_linebf(0,17,319,140,SKY);   //sky
   x = 160;
   y = b[1];
   int speed = 0;
   int jump = 0;
   int need_redraw = 1;

   fnt.setpos(0,22*8);
   fnt.color(128+15,0);
   fnt.writestring("                                      ");

   int nn=1;
   while (lives != 0) {
      while (a[2*nn]<323) {
         a[nn * 2 + 1] = a[nn * 2 ] +int(random(120))+10;
         a[nn * 2 + 2] = a[nn * 2 + 1] + 10 + int(random(200));
         b[nn +1] = 135 - int(random(40));
         nn++;
      }
      if( a[2]<0 ) {
        for(int abc=1; abc<nn; abc++) {
            a[(abc-1)*2+1] = a[abc*2+1];
            a[(abc-1)*2+2] = a[abc*2+2];
            b[abc]=b[abc+1];
        }
        nn--;
      }
    if (need_redraw) {
      fnt.setpos(0,1);
      fnt.color(128+15,0);
      if (cheat==0) {
         fnt.writestring("                SUPERCOW               ");
      } else {
         fnt.writestring("                *CHEATER*              "); 
	 cheat++;
      }
      if (cheat!=0) {
         if (cheat!=lastcheat) { 
            speedtotal=speedtotal/2;
            lastcheat=cheat;
         }
         if (cheat>90) cheat=0;
      }
    }
      if (need_redraw || speed) {
	      fnt.setpos(1,1);
	      fnt.color(128+15,128+15);
	      if (speed < 0) {
		 for (i = -1; i>speed-1; i--) fnt.writestring(">");  
		 lastdir=1;
	      } else
	      if (speed > 0) {
		 for (i = 1; i<speed+1; i++) fnt.writestring("<");
		 lastdir=-1;
	      }
	      fnt.setpos(8*5,1);
	      sprintf(string,"%i",speedtotal*-1/10);
	      fnt.writestring(string);
	      
	      fnt.setpos(8*34,1);
	      sprintf(string,"%i x",lives);
	      fnt.writestring(string);
	      //drawcow(8*39,13);
	      cow.setpos(8*37+3,3);
	      cow.drawscaled(13,10);

	      speedtotal += speed;
      }
      /*      
      for (n=1; n<(BLOECKE/2)-1; n++) {
         a[n * 2 + 1] = hejsan;
         a[n * 2 + 2] = hejsan + 10 + int(random(200));
         b[n + 1] = 135 - int(random(40));
         hejsan = a[n * 2 + 2] + int(random(120)) + 10;
      }
      */
  
      fall = 1;
      stanna = 0;

      if (ggiKbhit(cow.vis)) {
	 int key = ggiGetc(cow.vis);
         if (key == GIIUC_Escape) lives=0;
	 if (key == GIIK_Right) if (speed > -3) {
		 --speed; //forward
				}
	 if (key == GIIK_Left) if (speed < 3) {
		 ++speed; //backward
				}
	 if (key == GIIK_Up || key == GIIUC_Space)
            if (pm == 1) { 
               system("play ./supermoo.wav &");
               jump = 1; 
               yp = -4; 
               speedtotal++;
            } //jump
         if (key == GIIUC_F) if (y>37) {
            jump = 1; yp = -2;
            cheat = 1;
	 }
      }

      if (jump == 1) {
         y = y + yp; 
         yp = yp + 0.2;
         if (yp > 0.5) jump = 0;
      }

      //move the world
      for (n = 1; n<=nn*2 /*32*/; n++) {
         a[n] = a[n] + speed;
      }

      pm = 0;
      for (n = 1; n<=nn /*(BLOECKE/2)*/ /*16*/; n++) {
         if (x > a[n * 2 - 1] - 7) {
            if (x < a[n * 2] + 7) {
               if (int(y) >= int(b[n])) {
                  stanna = 1;
                  if (int(y) == int(b[n])) {
                     fall = 0;
                     stanna = 0;
                     pm = 1;
                  }
               }
            }
         }
      }
      
      if (stanna == 1) speed = 0;   //if touching ground from side, stop
      if (fall == 1) if (jump == 0) y = y + 0.8;

//fprintf(stderr, "stanna=%i, speed=%i, need_redraw=%i jump=%i fall=%i\n", stanna, speed, need_redraw, jump, fall);
      if (stanna == 0 && speed == 0 && need_redraw) {
//fprintf(stderr,"INITIAL\n");
          drawsun(70,40);
//   circle (70, 40, 12, RED);
          drawleftcloud();
          drawrightcloud();
          drawcow((int)x,(int)y);
//	  need_redraw = 0;
      }
      if (/*jump ||*/ fall) {
//fprintf(stderr,"REDRAW leftcloud\n");
	drawleftcloud();
        drawcow((int)x,(int)y);
      }

    /* if moving need to set the former ground to sky to mark the gaps */
    if (speed || stanna) {
//fprintf(stderr,"REDRAW cow\n");
      need_redraw = 1;
      for (n = 1; n<=nn /*(BLOECKE/2)*/ /*16*/; n++) {
         gl_linebf(a[n*2-1]-1, b[n],a[n*2-1]-3, 140, SKY); /* left border*/
         gl_linebf(a[n*2]  , b[n],a[n*2]+3,140, SKY ); /* right */
      }
      //clear left/right ground
      /*for (n=0; n<256; n++) {
         gl_setpixel(n,0,n);
      }*/
      
      drawcow((int)x,(int)y);
    }

      if (y > 140) {
         clearcow((int)x,(int)y);
         lives -= 1;
         y = 26;
      }

    if (need_redraw) {
//fprintf(stderr,"REDRAW ground\n");
      //paint meadow (green) and ground (brown)
      for (n = 1; n<=nn /*(BLOECKE/2)*/ /*16*/; n++) {
         gl_linebf(a[n*2-1],b[n],  a[n*2],b[n]+2,MEADOW); //2 grass
         gl_linebf(a[n*2-1],b[n]+3,a[n*2],140,EARTH); //6 earth
      }

      
      //update screen
      //vga_waitretrace(); //not necessarly, but too fast on fast computers

      // clearcow((int)x,(int)y);
      if (!speed) need_redraw = 0;
    }
//      ggiFlush(cow.vis);
   }

   ggiFillscreen(cow.vis);
   ggiClose(cow.vis);
   ggiExit();

   std::cout << "points " << -1 * speedtotal / 10 << std::endl;
   return 0;
}
