
/*

.spr ite format
x
y
body

.animated sprite format
x
y
body
body
.
.

.pcx format

color quantizitation
color remapping
color search and replace
animated sprites
*/

#include <math.h>
#include <stdio.h>

typedef unsigned char byte;

class sprite {
	public:
   ggi_visual_t vis;
   int xpos;
   int ypos;
   int xsize;
   int ysize;
   int clipping;       //0=no, other=yes
   int transparency;   //-1=no, 0=color 0..0 is transp., 4=0..4 is transp.
   ggi_pixel *spritedata;

   sprite();
   ~sprite();

//   byte getpixel(int x, int y);
//   void putpixel(int x, int y, byte color);
//  void savespr(char* filename);
//   void loadspr(char* filename);
//  void savepcx(char* filename);
   void loadpcx(char* filename);
   void generate(int x,int y);
   void free();

   void setpos(int x,int y);
//   void setproperties(int clip, int transp);
//   void move(int x,int y);

   void get(int x,int y,int x2,int y2);
//   void getlr(int x,int y,int x2,int y2);
   void draw();
//   void fill(int color);
//   void rescale(int newx, int newy);
   void rotate(int angle);
	//.perspective

   void drawscaled(int newx, int newy);
//   void drawrotated(int angle);
	//.drawperspective

   void leftright();

/*
   void shiftleft(int line);
   void shiftright(int line);
   void shiftup(int gap);
   void shiftdown(int gap);

   void rotleft(int line);
   void rotright(int line);
   void rotup(int gap);
   void rotdown(int gap);
*/
};

/*long fexist(char* name)
{
	struct ffblk ffblk;
	int done;
	done = findfirst(name,&ffblk,0);
	if (done==0) {
		return(ffblk.ff_fsize);
   } else {
    	return(-1);
   }
}*/

sprite::sprite()
{
	xsize=ysize=xpos=ypos=0;
   clipping=1;
   transparency=0;
   spritedata=NULL;
}

sprite::~sprite()
{
   delete[] spritedata;
}

void sprite::free()
{
   delete[] spritedata;
}
#if 0

void sprite::loadspr(char* filename)
{
   FILE* f=fopen(filename,"rb");
   int x,y;

   /*
   unsigned long i;

   fscanf(f,"%lu",&numpoints);
   fscanf(f,"%lu",&numconnections);

   pointlist=new p3d[numpoints];
   for(i=0; i<numpoints; i++) {
		fscanf(f,"%f",&pointlist[i].x);
      if (pointlist[i].x==0) pointlist[i].x=1;
		fscanf(f,"%f",&pointlist[i].y);
      if (pointlist[i].y==0) pointlist[i].y=1;
		fscanf(f,"%f",&pointlist[i].z);
      if (pointlist[i].z==0) pointlist[i].z=1;
   }
   */

   fclose(f);
}
#endif

/*
void sprite::savespr(char* filename)
{
   FILE* f=fopen(filename,"wb");

   fprintf(f,"%d%d",xsize,ysize);
   for(unsigned long i=0; i<1; i++) {
		fprintf(f,"%c",spritedata);
   }

   fclose(f);
}

void sprite::savepcx(char* filename)
{
   FILE* f=fopen(filename,"rb");
   fclose(f);
}
*/

void sprite::loadpcx(char* filename)
{
   FILE* f=fopen(filename,"rb");
   fclose(f);
}

void sprite::generate(int x,int y)
{
	if (spritedata==NULL) spritedata=new ggi_pixel[(x+1)*(y+1)+1];
}

void sprite::setpos(int x,int y)
{
   xpos=x;
   ypos=y;
}

/*
inline void sprite::setproperties(int clip, int transp)
{
	clipping=clip;
   transp=transparency;
}


inline void sprite::move(int x,int y)
{
	xpos+=x;
   ypos+=y;
}


byte sprite::getpixel(int x, int y)
{
	return(spritedata[x+y*(xsize+1)]);
}

void sprite::putpixel(int x, int y, byte color)
{
	//if ((x<=xsize) && (y<=ysize))
   spritedata[x+y*(xsize+1)]=color;
}
*/

void sprite::get(int x1,int y1,int x2,int y2)
{
	xsize=x2-x1;
   ysize=y2-y1;
   generate(xsize,ysize);
   for (int y=y1; y<y2; y++) {
	for (int x=x1; x<x2; x++) {
		//if (gl_getpixel(x,y)!=transparency)
//		if (spritedata[(x-x1)+((y-y1)*(xsize+1))] <= 128)
		ggiGetPixel(vis, x, y, (ggi_pixel*)&spritedata[(x-x1)+((y-y1)*(xsize+1))]);
	}
   }
}
/*
void sprite::getlr(int x1,int y1,int x2,int y2)
{
	xsize=x2-x1;
   ysize=y2-y1;
   generate(xsize,ysize);
   for (int y=y1; y<y2; y++) {
		for (int x=x2; x>x1; x--) {
      	//if (gl_getpixel(x,y)!=transparency)
		ggiGetPixel(vis, x, y, (ggi_pixel*)spritedata[(x-x1)+((y-y1)*(xsize+1))]);
      }
   }
}
*/

void sprite::draw()
{
	for (int y=0; y<ysize; y++) {
		for (int x=0; x<xsize; x++) {
      	if (spritedata[x+y*(xsize+1)]!=transparency)
			ggiPutPixel(vis,xpos+x,ypos+y,spritedata[x+y*(xsize+1)]);
      }
   }
   ggiFlushRegion(vis, xpos, ypos, xsize, ysize);
}

static inline void swap(ggi_pixel &a, ggi_pixel &b)
{
   ggi_pixel c=a;
   a=b;
   b=c;
}

void sprite::leftright()
{
   //unsigned char t;
	for (int y=0; y<ysize; y++) {
		for (int x=0; x<xsize/2; x++) {
         //t=spritedata[x+y*(xsize+1)];
         swap(spritedata[(25-x)+y*(xsize+1)],spritedata[x+y*(xsize+1)]);
      	//if (spritedata[x+y*(xsize+1)]!=transparency)
				//temp.putpixel(x,y,spritedata[(x)+y*(xsize+1)]);
      }
   }
	/*for (int y=0; y<ysize; y++) {
		for (int x=0; x<xsize; x++) {*/
      	//if (spritedata[x+y*(xsize+1)]!=transparency)
				//putpixel(25-x,y,temp.spritedata[(x)+y*(xsize+1)]);
/*      }
   }*/
   
}
/*

void sprite::fill(int color)
{
	for (int y=0; y<ysize; y++) {
		for (int x=0; x<xsize; x++) {
			spritedata[x+y*(xsize+1)]=color;
      }
   }
}


void sprite::rescale(int newx, int newy)
{
	sprite temp;
   temp.generate(newx,newy);
	for (int y=0; y<newy; y++) {
		for (int x=0; x<newx; x++) {
      	if (spritedata[x+y*(xsize+1)]!=transparency)
		ggiPutPixel(vis,xpos+x,ypos+y,spritedata[(x*xsize/newx)+((y*ysize/newy)*(xsize+1))]);
      }
   }
   free();
   generate(newx,newy);
   for (int x=0; x<newy*newy; x++) {
   	spritedata[x]=temp.spritedata[x];
   }
   ggiFlushRegion(vis, xpos, ypos, newx, newy);
   temp.free();
}
*/

void sprite::drawscaled(int newx, int newy)
{
	for (int y=0; y<newy; y++) {
		for (int x=0; x<newx; x++) {
      	if (spritedata[x+y*(xsize+1)]!=transparency)
				ggiPutPixel(vis,xpos+x,ypos+y,spritedata[(x*xsize/newx)+((y*ysize/newy)*(xsize+1))]);
      }
   }
   ggiFlushRegion(vis, xpos, ypos, newx, newy);
}
/*

void sprite::drawrotated(int angle)
{
   double rad = atan(1) * 4 / 180;
   int calcx, calcy;
   double anglerad = angle * rad;
   double cosar = cos(anglerad);
   double sinar = sin(anglerad);
   int xhalf=xsize/2;
   int yhalf=ysize/2;
	for (int x=0; x<xsize; x++) {
    	for (int y=0; y<ysize; y++) {
      	//if (spritedata[x+y*(xsize+1)]!=transparency)
   			calcx=(int)((x-(0.5+xhalf))*cosar - (y-(0.5+yhalf))*sinar);
         	calcy=(int)((y-(0.5+yhalf))*cosar + (x-(0.5+xhalf))*sinar);
				ggiPutPixel(vis,(xhalf)+xpos+calcx,(yhalf)+ypos+calcy,spritedata[x+y*(xsize+1)]);
      }
   }
}
*/

/*
Procedure PutRotatedImage(X,Y,Angle:Word;Var Img:Pointer;Where:Word);
Var Dx,Dy:Word;
    A,B:Word;
    Segm,Offs:Word;
    Xp,Yp:Integer;
    Xr,Yr:Integer;
    Xc,Yc:Integer;
    Color:Byte;
Begin
     Segm:=Seg(Img^);
     Offs:=Ofs(Img^);
     Move(Mem[Segm:Offs],Dx,2);
     Move(Mem[Segm:Offs+2],Dy,2);
     Offs:=Offs+4;
     Xc:=X+(Dx Div 2);
     Yc:=Y+(Dy Div 2);
     For A:=1 To Dy Do
       For B:=1 To Dx Do
       Begin
            { Calculate relative coordinates }
            Xp:=(X+B)-Xc;
            Yp:=(Y+A)-Yc;
            { Calculate rotated coordinates }
            Xr:=Trunc(Xp*Cosines^[Angle]-Yp*Sines^[Angle]);
            Yr:=Trunc(Yp*Cosines^[Angle]+Xp*Sines^[Angle]);
            { Add the value of the center }
            Xr:=Xr+Xc;
            Yr:=Yr+Yc;
            { Put the pixel }
            Color:=Mem[Segm:Offs];
            PutPixel(Xr,Yr,Color,Where);
            Inc(Offs);
       End;
End;

Procedure Scale(Image:Pointer;DeltaX,DeltaY:Word;Var Target:Pointer);
Var Segm1,Segm2,Offs1,Offs2:Word;
    XSize,YSize:Word;
    IndexX,IndexY,XRatio,YRatio:Real;
    Dx,Dy:Word;
    C:Byte;
Begin
     Segm1:=Seg(Image^);
     Offs1:=Ofs(Image^);
     Move(Mem[Segm1:Offs1],Xsize,2);
     Move(Mem[Segm1:Offs1+2],Ysize,2);
     GetMem(Target,DeltaX*DeltaY+4);
     Segm2:=Seg(Target^);
     Offs2:=Ofs(Target^);
     Move(DeltaX,Mem[Segm2:Offs2],2);
     Move(DeltaY,Mem[Segm2:Offs2+2],2);
     Offs2:=Offs2+4;
     XRatio:=XSize/DeltaX;
     YRatio:=YSize/DeltaY;
     IndexX:=0;
     IndexY:=0;
     For Dy:=1 To DeltaY Do
     Begin
          For Dx:=1 To DeltaX Do
          Begin
               Offs1:=Trunc(IndexY)*XSize+Trunc(IndexX)+4;
               C:=Mem[Segm1:Offs1];
               Mem[Segm2:Offs2]:=C;
               Inc(Offs2);
               IndexX:=IndexX+XRatio;
          End;
          IndexX:=0;
          IndexY:=IndexY+YRatio;
     End;
End;
*/
