#include <stdlib.h>
#include <stdio.h>
#include "pcx.h"

#include <ggi/ggi.h>

#define bsize 1024
pcx16 pcx16_load(ggi_visual_t vis, char *fn)
{
    pcx16 p;
    FILE *f;
    struct pcx_header hd;
    int type=0;
    unsigned char *tmp,bb,/*pal[768],*/n;
    ggi_color *pal = (ggi_color *)malloc(256*sizeof(ggi_color));
    uint8_t palbuf[4];
    int i,t;
    char decbuf[bsize];
    int left=0;
    char *ptr=NULL;
    int c,/*col,*/x,y;
    int cr,cg,cb;
    p=(struct _pcx16*)malloc(sizeof(struct _pcx16));
    if (!p) return(NULL);

    f=fopen(fn,"r");
    if (!f)
    {
        printf("file not found\n");
        free(p);
        return(NULL);
    }
    //    fseek(f,seekto,SEEK_SET);

    fread(&hd,128,1,f);
    if (hd.id!=0x0a)
    {
        printf("not a pcx\n");
        free(p);
        return(NULL);
    }
    if (hd.version!=5)
    {
        printf("not pcx 3.0\n");
        free(p);
        return(NULL);
    }

    /*
     format:        bpp   planes  type
     256 color      8     1       1
     true color     8     3       1
     */

    if (hd.bpp==8 && hd.planes==1 && hd.type==0) type=1;
    if (hd.bpp==8 && hd.planes==1 && hd.type==1) type=1;
    if (hd.bpp==8 && hd.planes==3 && hd.type==1) type=2;
    if (hd.bpp==8 && hd.planes==3 && hd.type==0) type=2;

    if (!type)
    {
        printf("unknown format (%d bpp,%d planes,type:%d)\n",hd.bpp,hd.planes,hd.type);
        free(p);
        return(NULL);
    }

    p->w = hd.x2 - hd.x1 + 1;
    p->h = hd.y2 - hd.y1 + 1;

    tmp=(unsigned char*)malloc(hd.bpl*p->h*hd.planes);

    printf("."); fflush(stdout);

    if (hd.comp)
        for (i=0;i<hd.bpl*p->h*hd.planes;i++)
        {
            if (!left)
            {
                left=fread(decbuf,1,bsize,f);
                ptr=decbuf;
            }
            bb=*ptr; left--; ptr++;
            
            if ((bb&0xc0)==0xc0)
            {
                n=bb&0x3f;

                if (!left)
                {
                    left=fread(decbuf,1,bsize,f);
                    ptr=decbuf;
                }
                bb=*ptr; left--; ptr++;
                
                for (t=0;t<n-1;t++)
                {
                    tmp[i]=bb;
                    i++;
                }
            }
            tmp[i]=bb;
        }
    else
        fread(tmp,hd.bpl*p->h*hd.planes,1,f);

    if (type==1)
    {
#if 0
        fseek(f,-768,SEEK_END);
        fread(pal,768,1,f);

	for (t=0; t<=767; t++) {
      pal[t]=pal[t]>>2;
   }
   ggiSetPalette(vis, 0,1 << hd.bpp, (ggi_color*)pal);
#else
	fseek(f,-768,SEEK_END);
	for (i=0; i<256;i++) {
		fread(palbuf, 1, 3, f);
		pal[i].r = palbuf[0] << 8;
		pal[i].g = palbuf[1] << 8;
		pal[i].b = palbuf[2] << 8;
	}
	ggiSetPalette(vis, 0, 1 << hd.bpp, pal);
#endif
    }
    fclose(f);

    printf("."); fflush(stdout);

    p->buf=(unsigned short*)malloc(p->w*p->h*2);
    p->buf8=(unsigned char*)malloc(p->w*p->h);
    if (!p->buf8)
    {
        printf("not enough memory\n");
        free(tmp);
        free(p);
        return(NULL);
    }
#if 1
    switch(type)
    {
    case 1:
       for (i=0;i<p->w*p->h;i++)
        {
	    p->buf8[i]=tmp[i];
/*            c=((int)tmp[i])*3;
            cr=pal[c+0]>>2;
            cg=pal[c+1]>>2;
            cb=pal[c+2]>>2;

            c=pal[c];//((cr<<10)&0xf800) | ((cg<<5)&0x07e0) | ((cb>>1)&0x001f);
            col=p->buf[i]=c;
*/
//            if (col==60) b->buf[i]=TRANSPARENT;
//            if (c==15*3 && flag) b->buf[i]=TRANSPARENT;
        }
        
        break;
    case 2:
        for (y=0;y<p->h;y++)
            for (x=0;x<p->w;x++)
            {
                cr=tmp[ x + (y*3+0)*p->w ]/4;
                cg=tmp[ x + (y*3+1)*p->w ]/4;
                cb=tmp[ x + (y*3+2)*p->w ]/4;
                c=((cr<<10)&0xf800) | ((cg<<5)&0x07e0) | ((cb>>1)&0x001f);
                p->buf[x+y*p->w]=c;
            }
        break;
    }

#endif
    free(tmp);
    printf("ok\n");
    return(p);
}
#undef bsize

void pcx16_free(pcx16 p)
{
    free(p->buf);
    free(p);
}
