
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "filesize.h"

class font {
	public:
   ggi_visual_t vis;
   unsigned char transparency;   // in percent
   ggi_color fgcolor;
   ggi_color bgcolor;
   unsigned char xsize,ysize;
   unsigned long xspace,yspace; //XXX unneeded, use xsize instead
   long xpos,ypos;

   unsigned long size;
   char* fontp;   // 1024 - 16384 bytes
   
   font();
   ~font();

   void load(char* filename);
//   void save(char* filename);
   void writechar(unsigned char c);
   void writestring(char* string);
//   void writecharscaled(unsigned char c, int x, int y);
//   void writestringscaled(char* string, int x, int y);
   void locate(int x, int y);
   void setpos(int x, int y);
   void color(unsigned char fg, unsigned char bg);
};

font::font()
{
   transparency=0;
	fgcolor.r=0xffff;
	fgcolor.g=0xffff;
	fgcolor.b=0xffff;
	fgcolor.a=0xffff;
	bgcolor.r=0x0000;
	bgcolor.g=0x0000;
	bgcolor.b=0x0000;
	bgcolor.a=0x0000;
	xpos=0;
   ypos=0;
   fontp=NULL;
}

font::~font()
{
 	delete[] fontp;
}

void font::load(char* filename)
{
	FILE* f;

   f=fopen(filename,"rb");
	size=filesize(f);
   if (size>16384) size=16384;
   fontp=new char[size];
	fread(fontp,size % 256,1,f);   //overread possible headers
	fread(fontp,size,1,f);
   fclose(f);

   xsize=8;
   xspace=xsize;
   ysize=size / 256;
   yspace=ysize;
   xpos=ypos=0;
}
/*

void font::save(char* filename)
{
	FILE* f;
   f=fopen(filename,"wb");
	fwrite(fontp,size-(size % 256),1,f);
   fclose(f);
}
*/

void font::writechar(unsigned char c)
{
	unsigned char x=0,y;
	unsigned char cha=c;	  //cha=ord(c);
	unsigned char cr=1;
	ggi_pixel fgpixel = ggiMapColor(vis, &fgcolor);
	ggi_pixel bgpixel = ggiMapColor(vis, &bgcolor);

   //if (xpos+xspace>vga_getxdim()+1) return;
/*
   if (xpos+xspace>vga_getxdim()+1) {
   	//xpos=0;
      //ypos=ypos+yspace;
      
      xpos=xpos-xspace*9;
   }
   if (ypos+yspace>vga_getydim()+1) {
      //ypos=0;
      
      ypos=ypos-yspace;
   }
   */

   for (y=0; y<=ysize-1; y++) {
      cr=fontp[cha*ysize+y];

      for (x=0; x<=xsize-1; x++) {
      	if ((cr & 0x80)!=0) {
				/*XXX if (gl_getpixel(xpos+x,ypos+y)!=1)*/ ggiPutPixel(vis,xpos+x,ypos+y,fgpixel);
			} else {
         	//if foregroundcolor and backgroundcolor are the same
            //then that means transparent background
         	if (fgcolor.r!=bgcolor.r||fgcolor.g!=bgcolor.g||fgcolor.b!=bgcolor.b)
			ggiPutPixel(vis,xpos+x,ypos+y,bgpixel);
			}
         cr=cr << 1;
      }
   }
   ggiFlushRegion(vis, xpos, ypos, x, y);
   xpos=xpos+xspace;
}

void font::writestring(char* string)
{
	int i;

   for (i=0; i<strlen(string); i++) {
   	if (string[i]=='\n') {
       	locate(1,ypos+2);
      } else {
      	writechar(string[i]);
      }
   }
}

void font::locate(int x, int y)
{
	xpos=(x-1)*xspace;
   ypos=(y-1)*yspace;
}

void font::setpos(int x, int y)
{
	xpos=x;
   ypos=y;
}

void font::color(unsigned char fg, unsigned char bg)
{
	switch (fg) {
		case  0:case 8: fgcolor.r=0;fgcolor.g=0;fgcolor.b=0; break;
		case  1:case 9: fgcolor.r=0xffff;fgcolor.g=0;fgcolor.b=0; break;
		case  2:case 10: fgcolor.r=0;fgcolor.g=0xffff;fgcolor.b=0; break;
		case  3:case 11: fgcolor.r=0xffff;fgcolor.g=0xffff;fgcolor.b=0; break;
		case  4:case 12: fgcolor.r=0;fgcolor.g=0;fgcolor.b=0xffff; break;
		case  5:case 13: fgcolor.r=0xffff;fgcolor.g=0;fgcolor.b=0xffff; break;
		case  6:case 14: case 15: fgcolor.r=0;fgcolor.g=0xffff;fgcolor.b=0xffff; break;
		case  7: fgcolor.r=0xffff;fgcolor.g=0xffff;fgcolor.b=0xffff; break;
/*		case  8: fgcolor.r=0;fgcolor.g=0;fgcolor.b=0; break;
		case  9: fgcolor.r=0;fgcolor.g=0;fgcolor.b=0; break;
		case 10: fgcolor.r=0;fgcolor.g=0;fgcolor.b=0; break;
		case 11: fgcolor.r=0;fgcolor.g=0;fgcolor.b=0; break;
		case 12: fgcolor.r=0;fgcolor.g=0;fgcolor.b=0; break;
		case 13: fgcolor.r=0;fgcolor.g=0;fgcolor.b=0; break;
		case 14: fgcolor.r=0;fgcolor.g=0;fgcolor.b=0; break;
		case 15: fgcolor.r=0;fgcolor.g=0;fgcolor.b=0; break;*/
	}
	switch (bg) {
		case  0:case 8: bgcolor.r=0;bgcolor.g=0;bgcolor.b=0; break;
		case  1:case 9: bgcolor.r=0xffff;bgcolor.g=0;bgcolor.b=0; break;
		case  2:case 10: bgcolor.r=0;bgcolor.g=0xffff;bgcolor.b=0; break;
		case  3:case 11: bgcolor.r=0xffff;bgcolor.g=0xffff;bgcolor.b=0; break;
		case  4:case 12: bgcolor.r=0;bgcolor.g=0;bgcolor.b=0xffff; break;
		case  5:case 13: bgcolor.r=0xffff;bgcolor.g=0;bgcolor.b=0xffff; break;
		case  6:case 14: case 15: bgcolor.r=0;bgcolor.g=0xffff;bgcolor.b=0xffff; break;
		case  7: bgcolor.r=0xffff;bgcolor.g=0xffff;bgcolor.b=0xffff; break;
/*		case  8: bgcolor.r=0;bgcolor.g=0;bgcolor.b=0; break;
		case  9: bgcolor.r=0;bgcolor.g=0;bgcolor.b=0; break;
		case 10: bgcolor.r=0;bgcolor.g=0;bgcolor.b=0; break;
		case 11: bgcolor.r=0;bgcolor.g=0;bgcolor.b=0; break;
		case 12: bgcolor.r=0;bgcolor.g=0;bgcolor.b=0; break;
		case 13: bgcolor.r=0;bgcolor.g=0;bgcolor.b=0; break;
		case 14: bgcolor.r=0;bgcolor.g=0;bgcolor.b=0; break;
		case 15: bgcolor.r=0;bgcolor.g=0;bgcolor.b=0; break;*/
	}


//XXX   bgcolor=bg;
}

/*
int main(int argc, char** argv)
{
	font schrift;
   schrift.load("4x6.fnt");
   schrift.xspace=5;
   schrift.yspace=7;

   setmode(0x13);

   schrift.writestring("hallo WELT");
   schrift.color(15,1);
   schrift.locate(1,3);
   schrift.writestring("0123456789abcdefghijklmnopqrstuvwxyz!?:;");
   schrift.color(15,2);
   schrift.locate(1,4);
   schrift.writestring("+\"*%&/()=ABCDEFGHIJKLMNOPQRSTUVWXYZ<>[]");
   schrift.color(15,15);

   char temp[20];
   for (int i=5; i<=28; i++) {
   	schrift.locate(1,i);
      itoa(i,temp,10);
      schrift.writestring(temp);
   }

   getch();
   setmode(0x03);

	return 0;
}
*/

/*
void font::writecharscaled(unsigned char c, int newx, int newy)
{
	for (int x=0; x<newx; x++) {
    	for (int y=0; y<newy; y++) {
      	if (spritedata[x+y*(xsize+1)]!=transparency)
				::gl_setpixel(xpos+x,ypos+y,spritedata[(x*xsize/newx)+((y*ysize/newy)*(xsize+1))]);
      }
   }
}

void font::writestringscaled(char* string, int newx, int newy)
{
	for (int x=0; x<newx; x++) {
    	for (int y=0; y<newy; y++) {
      	if (spritedata[x+y*(xsize+1)]!=transparency)
				::gl_setpixel(xpos+x,ypos+y,spritedata[(x*xsize/newx)+((y*ysize/newy)*(xsize+1))]);
      }
   }
}
*/
